﻿$(function () {

    function showInfo() {
        $('#overlay').show();
        $('#infoDialog').show();
    }

    function hideInfo() {
        $('#overlay').hide();
        $('#infoDialog').hide();
    }

    function zeroPad(num, places) {
        var zero = places - num.toString().length + 1;
        return Array(+(zero > 0 && zero)).join("0") + num;
    }

    var i,
        j,
        str,
        colors = ['Amethyst', 'Emerald', 'Ruby', 'Topaz'],
        cuts = ['Chipped', 'Flawed', '', 'Flawless', 'Perfect', 'Radiant', 'Square', 'Flawless Square', 'Perfect Square', 'Radiant Square', 'Star', 'Flawless Star', 'Perfect Star', 'Radiant Star'],
        cutIds = [1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15],
        selectedGem = null,
        wheel1 = { data: [], circular: false },
        wheel2 = { data: [], circular: false },
        wheels = [[wheel1], [wheel2]];

    for (i = 0; i < colors.length; i++) {
        wheel1.data.push({ display: '<div class="colors"><span>' + colors[i] + '</span></div>', value: i });
    }

    for (i = 0; i < cuts.length; i++) {
        str = '';
        for (j = 0; j < colors.length; j++) {
            str = str + '<div class="cuts cuts' + j + '"><div class="cut-img"><div class="img" style="background-position:' + (-34 * i) + 'px ' + (-34 * j) + 'px;"></div></div><div class="txt">' + (cuts[i] || colors[j]) + '</div></div>';
        }
        wheel2.data.push({ value: cutIds[i], display: str });
    }

    $("#gemselect").mobiscroll().scroller({
        theme: 'diablo',
        display: 'inline',
        mode: 'scroller',
        wheels: wheels,
        height: 40,
        minWidth: 135,
        showLabel: false,
        validate: function (event, inst) {
            var values = event.values,
                index = event.index,
                oldValues = (inst.getVal() || '0 0').split(''),
                newcolor = 'cuts' + values[0],
                oldcolor = 'cuts' + oldValues[0],
                cutid = +values[1],
                colorid = +values[0] + 1;

            if (!index) { // 0 or undefined
                $('.mbsc-fr-w', inst._markup).removeClass(oldcolor).addClass(newcolor);
            }

            if (selectedGem) {
                selectedGem.hide();
            }

            selectedGem = $('#gem_' + cutid + '_' + colorid).show();
        }
    });

    $('#infoIcon').click(showInfo);
    $('#closeDialog').click(hideInfo);
    $('#overlay').click(hideInfo);

});